﻿using System;
using Codeplex.OAuth;
using Livet;
using Livet.Command;
using Livet.Messaging.Window;

namespace Azyobuzi.Twikoto2.ViewModels
{
    public class InputPinWindowViewModel : ViewModel
    {
        public Uri AuthorizeUri { set; get; }

        public RequestToken RequestToken { set; get; }
                
        string _PinCode;

        public string PinCode
        {
            get
            { return _PinCode; }
            set
            {
                if (_PinCode == value)
                    return;
                _PinCode = value.Trim();
                RaisePropertyChanged("PinCode");
                this.OKCommand.RaiseCanExecuteChanged();
            }
        }
        
        #region OKCommand
        DelegateCommand _OKCommand;

        public DelegateCommand OKCommand
        {
            get
            {
                if (_OKCommand == null)
                    _OKCommand = new DelegateCommand(OK, CanOK);
                return _OKCommand;
            }
        }

        private bool CanOK()
        {
            return !string.IsNullOrWhiteSpace(this.PinCode);
        }

        private void OK()
        {
            this.Messenger.Raise(new WindowActionMessage("ChangeWindowState", WindowAction.Close));
        }
        #endregion

        
        bool _Closed = false;

        public bool Closed
        {
            get
            { return _Closed; }
            set
            {
                if (_Closed == value)
                    return;
                _Closed = value;
                RaisePropertyChanged("Closed");
            }
        }
      
    }
}
